

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of DFFE is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_LOGIC := 'X';
   SIGNAL CLRN_ipd	 : STD_LOGIC := 'X';
   SIGNAL PRN_ipd	 : STD_LOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_LOGIC := 'X';
   SIGNAL ENA_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (D_ipd, D, VitalExtendToFillDelay(tipd_D));
   VitalPropagateWireDelay (CLRN_ipd, CLRN, VitalExtendToFillDelay(tipd_CLRN));
   VitalPropagateWireDelay (PRN_ipd, PRN, VitalExtendToFillDelay(tipd_PRN));
   VitalPropagateWireDelay (CLK_ipd, CLK, VitalExtendToFillDelay(tipd_CLK));
   VitalPropagateWireDelay (ENA_ipd, ENA, VitalExtendToFillDelay(tipd_ENA));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLRN_ipd, PRN_ipd, CLK_ipd, ENA_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK	: X01 := '0';
   VARIABLE Tmkr_D_CLK	: TimeMarkerType;

   -- functionality results
   VARIABLE Violation : X01 := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(1 to 7) := (others => 'X');
   VARIABLE D_delayed : STD_LOGIC := 'X';
   VARIABLE CLK_delayed : STD_LOGIC := 'X';
   VARIABLE ENA_delayed : STD_LOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: GlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalTimingCheck (D_ipd, "D", CLK_ipd, "CLK",
                           tsetup_D_CLK_posedge, tsetup_D_CLK_negedge,
                           thold_CLK_D_posedge, thold_CLK_D_negedge,
                           TO_X01(( (NOT PRN_ipd) ) OR ( (NOT CLRN_ipd) ) )
                            /= '1',
                           TO_X01(CLK_ipd) = '1',
                           InstancePath & "/DFFE",
                           Tmkr_D_CLK, Tviol_D_CLK);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK;
      VitalStateTable(
        StateTable => DFFE_Q_tab,
        DataIn => (
               CLRN_ipd, D_delayed, ENA_delayed, CLK_delayed, PRN_ipd, ENA_ipd, CLK_ipd),
        Result => Q_zd,
        PreviousDataIn => PrevData_Q);
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;
      ENA_delayed := ENA_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Q,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (PRN_ipd'last_event, VitalExtendToFillDelay(tpd_PRN_Q_negedge), TRUE),
                 1 => (CLRN_ipd'last_event, VitalExtendToFillDelay(tpd_CLRN_Q_negedge), TRUE),
                 2 => (CLK_ipd'last_event, VitalExtendToFillDelay(tpd_CLK_Q_posedge), TRUE),
                 3 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_CLK_Q_posedge), TRUE),
                 4 => (ENA_ipd'last_event, VitalExtendToFillDelay(tpd_ENA_Q), TRUE)),
       GlitchData => Q_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;